/*
 * Decompiled with CFR 0.152.
 */
package de.looksgood.ani;

import de.looksgood.ani.Ani;
import java.util.ArrayList;
import processing.core.PApplet;

public class AniSequence {
    private PApplet papplet;
    private ArrayList<Step> steps = new ArrayList();
    private ArrayList<Ani> addParallelAnisCollector = new ArrayList();
    private boolean addParallel = false;
    private boolean isPlaying = false;
    private boolean isEnded = false;
    private int currentStep;
    private float durationTotal;
    private float time;

    public AniSequence(PApplet thePapplet) {
        this.papplet = thePapplet;
        this.papplet.registerMethod("pre", (Object)this);
    }

    public void pre() {
        if (this.isPlaying) {
            this.update();
        }
    }

    private void update() {
        if (this.steps.size() > 0) {
            Step tmpStep = this.steps.get(this.currentStep);
            if (tmpStep.isFinished() && this.currentStep < this.steps.size() - 1) {
                ++this.currentStep;
                Step nextStep = this.steps.get(this.currentStep);
                nextStep.start();
                tmpStep = nextStep;
            } else if (this.currentStep == this.steps.size() - 1) {
                this.isEnded = tmpStep.isFinished();
            }
            this.time = tmpStep.startTime + tmpStep.getTime();
        }
    }

    public void seek(float theValue) {
        Step tmpStep;
        this.isEnded = false;
        theValue = PApplet.constrain((float)theValue, (float)0.0f, (float)1.0f);
        this.time = theValue * this.durationTotal;
        int i = this.steps.size() - 1;
        while (i >= 0) {
            tmpStep = this.steps.get(i);
            if (this.time >= tmpStep.startTime && this.time < tmpStep.endTime) {
                this.currentStep = i;
                break;
            }
            --i;
        }
        i = this.steps.size() - 1;
        while (i >= this.currentStep) {
            tmpStep = this.steps.get(i);
            if (i == this.currentStep) {
                float stepSeekTime = this.time - tmpStep.startTime;
                float stepSeekValue = PApplet.map((float)stepSeekTime, (float)0.0f, (float)tmpStep.duration, (float)0.0f, (float)1.0f);
                tmpStep.seek(Float.valueOf(stepSeekValue));
                break;
            }
            tmpStep.seekAll(Float.valueOf(0.0f));
            --i;
        }
    }

    public void add(Ani theAni) {
        if (this.addParallel) {
            this.addParallelAnisCollector.add(theAni);
        } else {
            Step tmpStep = new Step(theAni);
            this.steps.add(tmpStep);
        }
    }

    public void add(Ani[] theAnis) {
        if (!this.addParallel) {
            this.beginStep();
            int i = 0;
            while (i < theAnis.length) {
                this.add(theAnis[i]);
                ++i;
            }
            this.endStep();
        } else {
            int i = 0;
            while (i < theAnis.length) {
                this.add(theAnis[i]);
                ++i;
            }
        }
    }

    public void beginStep() {
        this.addParallelAnisCollector = new ArrayList();
        this.addParallel = true;
    }

    public void endStep() {
        Ani[] tmpAnis = new Ani[this.addParallelAnisCollector.size()];
        int i = 0;
        while (i < tmpAnis.length) {
            tmpAnis[i] = this.addParallelAnisCollector.get(i);
            ++i;
        }
        Step tmpStep = new Step(tmpAnis);
        this.steps.add(tmpStep);
        this.addParallel = false;
    }

    public void start() {
        this.isPlaying = true;
        this.isEnded = false;
        this.reconstruct();
        Step tmpStep = this.steps.get(this.currentStep);
        tmpStep.start();
    }

    public void resume() {
        Step tmpStep = this.steps.get(this.currentStep);
        tmpStep.play();
        this.isPlaying = true;
        this.isEnded = false;
    }

    public void pause() {
        Step tmpStep = this.steps.get(this.currentStep);
        tmpStep.pause();
        this.isPlaying = false;
    }

    public void beginSequence() {
        Ani.noAutostart();
        Ani.noOverwrite();
    }

    public void endSequence() {
        Ani.autostart();
        Ani.overwrite();
        this.reconstruct();
    }

    private void reconstruct() {
        Step tmpStep;
        this.currentStep = 0;
        this.durationTotal = 0.0f;
        int i = 0;
        while (i < this.steps.size()) {
            tmpStep = this.steps.get(i);
            tmpStep.pause();
            tmpStep.startTime = this.durationTotal;
            tmpStep.endTime = this.durationTotal + tmpStep.duration;
            this.durationTotal += tmpStep.duration;
            ++i;
        }
        i = this.steps.size() - 1;
        while (i >= 0) {
            tmpStep = this.steps.get(i);
            tmpStep.seekAll(Float.valueOf(0.0f));
            --i;
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public boolean isEnded() {
        return this.isEnded;
    }

    public float getSeek() {
        return PApplet.constrain((float)(this.time / this.durationTotal), (float)0.0f, (float)1.0f);
    }

    public float getDuration() {
        return this.durationTotal;
    }

    public int getStepNumber() {
        return this.currentStep + 1;
    }

    public int getStepCount() {
        return this.steps.size();
    }

    public float getTime() {
        return this.time;
    }

    private class Step {
        public ArrayList<Ani> anis = new ArrayList();
        public int stepLength;
        public float duration;
        public float startTime;
        public float endTime;

        public Step(Ani _ani) {
            this.anis.add(_ani);
            this.init();
        }

        public Step(Ani[] _anis) {
            int i = 0;
            while (i < _anis.length) {
                this.anis.add(_anis[i]);
                ++i;
            }
            this.init();
        }

        private void init() {
            this.stepLength = this.anis.size();
            this.duration = 0.0f;
            int i = 0;
            while (i < this.stepLength) {
                Ani tmpAni = this.anis.get(i);
                tmpAni.setBegin();
                tmpAni.seek(1.0f);
                this.duration = PApplet.max((float)tmpAni.getDurationTotal(), (float)this.duration);
                ++i;
            }
        }

        public boolean isFinished() {
            boolean isFinished = true;
            int i = 0;
            while (i < this.stepLength) {
                Ani tmpAni = this.anis.get(i);
                isFinished &= tmpAni.isEnded();
                ++i;
            }
            return isFinished;
        }

        public void start() {
            int i = 0;
            while (i < this.stepLength) {
                this.anis.get(i).start();
                ++i;
            }
        }

        public void seekAll(Float _value) {
            int i = 0;
            while (i < this.stepLength) {
                Ani tmpAni = this.anis.get(i);
                tmpAni.seek(_value.floatValue());
                ++i;
            }
        }

        public void seek(Float _value) {
            float seekTime = _value.floatValue() * this.duration;
            int i = 0;
            while (i < this.stepLength) {
                Ani tmpAni = this.anis.get(i);
                float aniSeekValue = PApplet.map((float)seekTime, (float)0.0f, (float)tmpAni.getDurationTotal(), (float)0.0f, (float)1.0f);
                tmpAni.seek(aniSeekValue);
                ++i;
            }
        }

        public float getTime() {
            float currentTime = 0.0f;
            int i = 0;
            while (i < this.stepLength) {
                Ani tmpAni = this.anis.get(i);
                float seekValue = tmpAni.getSeek() * tmpAni.getDurationTotal();
                currentTime = PApplet.max((float)seekValue, (float)currentTime);
                ++i;
            }
            return currentTime;
        }

        public void play() {
            int i = 0;
            while (i < this.stepLength) {
                this.anis.get(i).resume();
                ++i;
            }
        }

        public void pause() {
            int i = 0;
            while (i < this.stepLength) {
                this.anis.get(i).pause();
                ++i;
            }
        }
    }
}

