/*
 * Decompiled with CFR 0.152.
 */
package de.looksgood.ani;

import de.looksgood.ani.Ani;
import de.looksgood.ani.AniConstants;
import de.looksgood.ani.easing.Easing;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import processing.core.PApplet;

public class AniCore
implements AniConstants {
    private PApplet papplet;
    private String id;
    private String targetName;
    private String fieldName;
    private boolean isRegistered = false;
    private Object targetObject;
    private Field targetField;
    private Class<?> targetObjectFieldType;
    private float position;
    private float begin;
    private float change;
    private float end;
    private float beginTime;
    private float time;
    private float durationEasing;
    private float durationDelay;
    private float durationTotal;
    private String timeMode;
    private float pauseTime = 0.0f;
    private Easing easing;
    private Object callbackObject;
    private Method callbackStartMethod;
    private Class<?> callbackStartParameterClass;
    private Method callbackFinishMethod;
    private Class<?> callbackFinishParameterClass;
    private Method callbackUpdateMethod;
    private Class<?> callbackUpdateParameterClass;
    private Method callbackDelayMethod;
    private Class<?> callbackDelayParameterClass;
    private String playMode = "FORWARD";
    private String playDirection = "FORWARD";
    private int repeatNumber;
    private int repeatCount = 1;
    private boolean isRepeating = false;
    private boolean isDelaying = false;
    private boolean isPlaying = false;
    private boolean isEnded = false;

    public AniCore(PApplet thePapplet, String theAutostart, Object theTargetObject, float theDurationEasing, float theDurationDelay, String theTargetObjectFieldName, float theEnd, Easing theEasing, String theTimeMode, Object theCallbackObject, String theCallback) {
        this.papplet = thePapplet;
        this.callbackObject = theCallbackObject;
        this.targetObject = theTargetObject;
        this.targetName = this.targetObject.toString();
        this.fieldName = theTargetObjectFieldName;
        this.id = String.valueOf(this.targetName) + "_" + this.fieldName;
        this.end = theEnd;
        this.durationEasing = theDurationEasing;
        this.durationDelay = theDurationDelay;
        this.durationTotal = this.durationEasing + this.durationDelay;
        this.timeMode = theTimeMode;
        this.setEasing(theEasing);
        this.setCallback(theCallback);
        boolean setBeginSuccess = this.setBegin();
        if (setBeginSuccess && theAutostart == "AUTOSTART") {
            this.start();
        }
    }

    public boolean setBegin() {
        boolean foundField;
        boolean foundType;
        block13: {
            foundType = false;
            foundField = false;
            Class<?> targetClass = this.targetObject.getClass();
            while (targetClass != null) {
                int i = 0;
                while (i < targetClass.getDeclaredFields().length) {
                    if (targetClass.getDeclaredFields()[i].getName().equals(this.fieldName)) {
                        this.targetObjectFieldType = targetClass.getDeclaredFields()[i].getType();
                        foundField = true;
                        break;
                    }
                    ++i;
                }
                if (foundField) break;
                targetClass = targetClass.getSuperclass();
            }
            if (foundField) {
                try {
                    this.targetField = targetClass.getDeclaredField(this.fieldName);
                    try {
                        this.targetField.setAccessible(true);
                    }
                    catch (AccessControlException e) {
                        this.printSecurityWarning(e);
                    }
                    try {
                        if (this.targetObjectFieldType == Float.TYPE) {
                            this.begin = this.targetField.getFloat(this.targetObject);
                            foundType = true;
                            break block13;
                        }
                        if (this.targetObjectFieldType == Integer.TYPE) {
                            this.begin = new Float(this.targetField.getInt(this.targetObject)).floatValue();
                            foundType = true;
                            break block13;
                        }
                        String text = "### Ani Debug -> Wrong Type @ AniCore " + this.targetName + " (" + this.targetField.getType().getName() + ")" + " is not float or int";
                        throw new ClassCastException(text);
                    }
                    catch (Exception ex) {
                        this.printSecurityWarning(ex);
                    }
                }
                catch (NoSuchFieldException e) {
                    System.out.println("### Ani Debug ->  Error @ AniCore. " + e);
                }
            }
        }
        if (foundType && foundField) {
            this.change = this.end - this.begin;
            return true;
        }
        return false;
    }

    public void setBegin(float theBegin) {
        this.begin = theBegin;
        this.change = this.end - this.begin;
    }

    public Object getCallbackObject() {
        return this.callbackObject;
    }

    public void setCallbackObject(Object theCallbackObject) {
        this.callbackObject = theCallbackObject;
    }

    public void setCallback(String theCallback) {
        if (theCallback.length() > 0) {
            String[] propertyList = PApplet.split((String)theCallback, (char)',');
            int i = 0;
            while (i < propertyList.length) {
                String[] p = PApplet.split((String)PApplet.trim((String)propertyList[i]), (char)':');
                if (p.length == 2 && (p[0].equals("onStart") || p[0].equals("onEnd") || p[0].equals("onDelayEnd") || p[0].equals("onUpdate"))) {
                    String targetMethodName = p[1];
                    boolean foundMethod = false;
                    Class<?> targetClass = this.callbackObject.getClass();
                    Method targetMethod = null;
                    Class<Ani> tagetMethodParameterClass = null;
                    while (targetClass != null) {
                        int ii = 0;
                        while (ii < targetClass.getDeclaredMethods().length) {
                            if (targetClass.getDeclaredMethods()[ii].getName().equals(targetMethodName)) {
                                if (targetClass.getDeclaredMethods()[ii].getParameterTypes().length == 1) {
                                    if (targetClass.getDeclaredMethods()[ii].getParameterTypes()[0] == Ani.class) {
                                        tagetMethodParameterClass = Ani.class;
                                        foundMethod = true;
                                        break;
                                    }
                                } else if (targetClass.getDeclaredMethods()[ii].getParameterTypes().length == 0) {
                                    tagetMethodParameterClass = null;
                                    foundMethod = true;
                                    break;
                                }
                            }
                            ++ii;
                        }
                        if (foundMethod) break;
                        targetClass = targetClass.getSuperclass();
                    }
                    if (foundMethod) {
                        try {
                            Class[] classArray;
                            if (tagetMethodParameterClass == null) {
                                classArray = new Class[]{};
                            } else {
                                Class[] classArray2 = new Class[1];
                                classArray = classArray2;
                                classArray2[0] = Ani.class;
                            }
                            Class[] args = classArray;
                            targetMethod = targetClass.getDeclaredMethod(targetMethodName, args);
                            targetMethod.setAccessible(true);
                            if (p[0].equals("onStart")) {
                                this.callbackStartMethod = targetMethod;
                                this.callbackStartParameterClass = tagetMethodParameterClass;
                            } else if (p[0].equals("onEnd")) {
                                this.callbackFinishMethod = targetMethod;
                                this.callbackFinishParameterClass = tagetMethodParameterClass;
                            } else if (p[0].equals("onDelayEnd")) {
                                this.callbackDelayMethod = targetMethod;
                                this.callbackDelayParameterClass = tagetMethodParameterClass;
                            } else if (p[0].equals("onUpdate")) {
                                this.callbackUpdateMethod = targetMethod;
                                this.callbackUpdateParameterClass = tagetMethodParameterClass;
                            }
                        }
                        catch (SecurityException e) {
                            this.printSecurityWarning(e);
                        }
                        catch (NoSuchMethodException e) {
                            System.out.println("### Ani Debug ->  Error @ AniCore -> setCallbackMethods(). " + e);
                        }
                    } else {
                        System.out.println("### Ani Debug ->  Error @ AniCore -> setCallbackMethods(). Can't find a method of name: " + targetMethodName);
                    }
                }
                ++i;
            }
        }
    }

    private void dispatchOnStart() {
        if (this.callbackStartMethod != null) {
            try {
                Object[] objectArray;
                if (this.callbackStartParameterClass == null) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = this;
                }
                Object[] args = objectArray;
                this.callbackStartMethod.invoke(this.callbackObject, args);
            }
            catch (Exception e) {
                System.out.println("### Ani Debug ->  Error @ AniCore -> dispatchOnStart(). " + e);
            }
        }
    }

    private void dispatchOnEnd() {
        if (this.callbackFinishMethod != null) {
            try {
                Object[] objectArray;
                if (this.callbackFinishParameterClass == null) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = this;
                }
                Object[] args = objectArray;
                this.callbackFinishMethod.invoke(this.callbackObject, args);
            }
            catch (Exception e) {
                System.out.println("### Ani Debug ->  Error @ AniCore -> dispatchOnFinish(). " + e);
            }
        }
    }

    private void dispatchOnUpdate() {
        if (this.callbackUpdateMethod != null) {
            try {
                Object[] objectArray;
                if (this.callbackUpdateParameterClass == null) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = this;
                }
                Object[] args = objectArray;
                this.callbackUpdateMethod.invoke(this.callbackObject, args);
            }
            catch (Exception e) {
                System.out.println("### Ani Debug ->  Error @ AniCore -> dispatchOnUpdate(). " + e);
            }
        }
    }

    private void dispatchOnDelayEnd() {
        if (this.callbackDelayMethod != null) {
            try {
                Object[] objectArray;
                if (this.callbackDelayParameterClass == null) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = this;
                }
                Object[] args = objectArray;
                this.callbackDelayMethod.invoke(this.callbackObject, args);
            }
            catch (Exception e) {
                System.out.println("### Ani Debug ->  Error @ AniCore -> dispatchOnFinish(). " + e);
            }
        }
    }

    private void printSecurityWarning(Exception theE) {
        System.out.print("### Ani Debug ->  Error @ AniCore. ");
        System.out.println(theE);
    }

    public void pre() {
        if (this.isPlaying) {
            this.update();
        }
    }

    public void start() {
        if (!this.isRegistered) {
            this.papplet.registerMethod("pre", (Object)this);
            this.isRegistered = true;
            this.repeatNumber = 1;
            this.dispatchOnStart();
        }
        this.seek(0.0f);
        this.isPlaying = true;
        this.isEnded = false;
    }

    public void end() {
        this.isDelaying = false;
        this.seek(1.0f);
        this.isPlaying = false;
        this.isEnded = true;
        if (this.isRegistered) {
            this.papplet.unregisterMethod("pre", (Object)this);
            this.isRegistered = false;
        }
        this.dispatchOnEnd();
    }

    private void update() {
        this.setTime(this.getTime());
        if (this.time < this.durationDelay) {
            this.isDelaying = true;
            this.position = this.begin;
        } else {
            if (this.isDelaying) {
                this.setBegin();
                this.position = this.begin;
                this.dispatchOnDelayEnd();
            }
            this.isDelaying = false;
            if (this.time >= this.durationTotal) {
                if (this.isRepeating) {
                    if (this.repeatCount == 1 || this.repeatNumber <= this.repeatCount - 1 || this.repeatCount == -1) {
                        if (this.playMode == "YOYO") {
                            this.reverse();
                        }
                        this.start();
                        ++this.repeatNumber;
                    } else {
                        this.isRepeating = false;
                    }
                } else {
                    this.end();
                }
            } else {
                this.updatePosition();
            }
            this.updateTargetObjectField();
            this.dispatchOnUpdate();
        }
    }

    private void updatePosition() {
        try {
            this.position = this.easing.calcEasing(this.time - this.durationDelay, this.begin, this.change, this.durationEasing);
        }
        catch (Exception e) {
            System.out.println("### Ani Debug ->  Error @ AniCore -> updatePosition(). " + e);
        }
    }

    private void updateTargetObjectField() {
        try {
            if (this.targetObjectFieldType == Float.TYPE) {
                this.targetField.setFloat(this.targetObject, this.position);
            } else if (this.targetObjectFieldType == Integer.TYPE) {
                this.targetField.setInt(this.targetObject, (int)this.position);
            }
        }
        catch (Exception e) {
            System.out.println("### Ani Debug ->  Error @ AniCore -> updateTargetObjectField(). " + e);
        }
    }

    private float getTime() {
        return this.timeMode == "SECONDS" ? ((float)this.papplet.millis() - this.beginTime) / 1000.0f : (float)this.papplet.frameCount - this.beginTime;
    }

    private void setTime(float theTime) {
        this.time = theTime;
        this.beginTime = this.timeMode == "SECONDS" ? (float)this.papplet.millis() - this.time * 1000.0f : (float)this.papplet.frameCount - this.time;
    }

    public void pause() {
        this.isPlaying = false;
        this.pauseTime = this.getTime();
    }

    public void resume() {
        if (!this.isRegistered) {
            this.papplet.registerMethod("this", (Object)this);
            this.isRegistered = true;
        }
        if (!this.isPlaying && !this.isEnded) {
            this.isPlaying = true;
            this.seek(this.pauseTime / this.durationTotal);
        }
    }

    public void seek(float theValue) {
        theValue = PApplet.constrain((float)theValue, (float)0.0f, (float)1.0f);
        this.setTime(theValue * this.durationTotal);
        this.pauseTime = this.time;
        this.isEnded = false;
        if (this.time < this.durationDelay) {
            this.position = this.begin;
        } else {
            this.updatePosition();
        }
        this.updateTargetObjectField();
    }

    public float getSeek() {
        return PApplet.constrain((float)(this.time / this.durationTotal), (float)0.0f, (float)1.0f);
    }

    public void reverse() {
        float endTemp;
        float beginTemp = this.begin;
        this.begin = endTemp = this.end;
        this.end = beginTemp;
        this.change = this.end - this.begin;
        if (this.playDirection == "FORWARD") {
            this.playDirection = "BACKWARD";
        } else if (this.playDirection == "BACKWARD") {
            this.playDirection = "FORWARD";
        }
    }

    public String getTimeMode() {
        return this.timeMode;
    }

    public void setTimeMode(String theTimeMode) {
        this.timeMode = theTimeMode;
    }

    public Easing getEasing() {
        return this.easing;
    }

    public void setEasing(Easing theEasing) {
        this.easing = theEasing;
    }

    public String getPlayMode() {
        return this.playMode;
    }

    public void setPlayMode(String thePlayMode) {
        String oldPlayDirection = this.playDirection;
        if (thePlayMode == "FORWARD") {
            if (oldPlayDirection == "BACKWARD") {
                this.reverse();
            }
            this.playDirection = "FORWARD";
            this.playMode = "FORWARD";
        } else if (thePlayMode == "BACKWARD") {
            if (oldPlayDirection == "FORWARD") {
                this.reverse();
            }
            this.playDirection = "BACKWARD";
            this.playMode = "BACKWARD";
        } else if (thePlayMode == "YOYO") {
            this.playMode = "YOYO";
        }
    }

    public void repeat() {
        this.isRepeating = true;
        this.repeatCount = -1;
    }

    public void noRepeat() {
        this.isRepeating = false;
        this.repeatCount = 1;
    }

    public void repeat(int theRepeatCount) {
        if (theRepeatCount > 1) {
            this.isRepeating = true;
            this.repeatCount = theRepeatCount;
        } else {
            this.isRepeating = false;
            this.repeatCount = 1;
        }
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public int getRepeatNumber() {
        return this.repeatNumber;
    }

    public String getDirection() {
        return this.playDirection;
    }

    public float getPosition() {
        return this.position;
    }

    public float getBegin() {
        return this.begin;
    }

    public void setEnd(float theEnd) {
        this.end = theEnd;
        this.change = this.end - this.begin;
    }

    public float getEnd() {
        return this.end;
    }

    public float getDurationTotal() {
        return this.durationTotal;
    }

    public float getDelay() {
        return this.durationDelay;
    }

    public void setDelay(float theDurationDelay) {
        this.durationDelay = theDurationDelay;
        this.durationTotal = this.durationEasing + this.durationDelay;
    }

    public float getDuration() {
        return this.durationEasing;
    }

    public void setDuration(float theDurationEasing) {
        this.durationEasing = theDurationEasing;
        this.durationTotal = this.durationEasing + this.durationDelay;
    }

    public String getId() {
        return this.id;
    }

    public boolean isEnded() {
        return this.isEnded;
    }

    public boolean isRepeating() {
        return this.isRepeating;
    }

    public boolean isDelaying() {
        return this.isDelaying;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }
}

