/*
 * Decompiled with CFR 0.152.
 */
package de.looksgood.ani;

import de.looksgood.ani.AniCore;
import de.looksgood.ani.easing.Easing;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import processing.core.PApplet;

public class Ani
extends AniCore {
    private static PApplet papplet;
    private static HashMap<String, Ani> anisLookup;
    private static String defaultTimeMode;
    private static Easing defaultEasing;
    private static String defaultAutostartMode;
    private static String defaultCallback;
    private static String defaultOverwriteMode;

    static {
        anisLookup = new HashMap();
        defaultTimeMode = "SECONDS";
        defaultEasing = EXPO_OUT;
        defaultAutostartMode = "AUTOSTART";
        defaultCallback = "";
        defaultOverwriteMode = "OVERWRITE";
    }

    public static void init(PApplet thePapplet) {
        papplet = thePapplet;
        Ani.welcome();
    }

    private static void welcome() {
        System.out.println("Ani 2.7 infos, feedback @ http://benedikt-gross.de/libraries/Ani/");
    }

    public static PApplet papplet() {
        if (papplet == null) {
            throw new LibraryNotInitializedException();
        }
        return papplet;
    }

    public Ani(Object theTarget, float theDuration, String theFieldName, float theEnd) {
        super(Ani.papplet(), defaultAutostartMode, theTarget, theDuration, 0.0f, theFieldName, theEnd, defaultEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public Ani(Object theTarget, float theDuration, float theDelay, String theFieldName, float theEnd) {
        super(Ani.papplet(), defaultAutostartMode, theTarget, theDuration, theDelay, theFieldName, theEnd, defaultEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public Ani(Object theTarget, float theDuration, String theFieldName, float theEnd, Easing theEasing) {
        super(Ani.papplet(), defaultAutostartMode, theTarget, theDuration, 0.0f, theFieldName, theEnd, theEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public Ani(Object theTarget, float theDuration, float theDelay, String theFieldName, float theEnd, Easing theEasing) {
        super(Ani.papplet(), defaultAutostartMode, theTarget, theDuration, theDelay, theFieldName, theEnd, theEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public Ani(Object theTarget, float theDuration, String theFieldName, float theEnd, Easing theEasing, String theCallback) {
        super(Ani.papplet(), defaultAutostartMode, theTarget, theDuration, 0.0f, theFieldName, theEnd, theEasing, defaultTimeMode, theTarget, theCallback);
    }

    public Ani(Object theTarget, float theDuration, float theDelay, String theFieldName, float theEnd, Easing theEasing, String theCallback) {
        super(Ani.papplet(), defaultAutostartMode, theTarget, theDuration, theDelay, theFieldName, theEnd, theEasing, defaultTimeMode, theTarget, theCallback);
    }

    public Ani(Object theTarget, float theDuration, float theDelay, String theFieldName, float theEnd, Easing theEasing, Object theCallbackObject, String theCallback) {
        super(Ani.papplet(), defaultAutostartMode, theTarget, theDuration, theDelay, theFieldName, theEnd, theEasing, defaultTimeMode, theCallbackObject, theCallback);
    }

    public static Ani to(Object theTarget, float theDuration, String theFieldName, float theEnd) {
        return Ani.addAni(false, theTarget, theDuration, 0.0f, theFieldName, theEnd, defaultEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public static Ani from(Object theTarget, float theDuration, String theFieldName, float theEnd) {
        return Ani.addAni(true, theTarget, theDuration, 0.0f, theFieldName, theEnd, defaultEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public static Ani to(Object theTarget, float theDuration, float theDelay, String theFieldName, float theEnd) {
        return Ani.addAni(false, theTarget, theDuration, theDelay, theFieldName, theEnd, defaultEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public static Ani from(Object theTarget, float theDuration, float theDelay, String theFieldName, float theEnd) {
        return Ani.addAni(true, theTarget, theDuration, theDelay, theFieldName, theEnd, defaultEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public static Ani to(Object theTarget, float theDuration, String theFieldName, float theEnd, Easing theEasing) {
        return Ani.addAni(false, theTarget, theDuration, 0.0f, theFieldName, theEnd, theEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public static Ani from(Object theTarget, float theDuration, String theFieldName, float theEnd, Easing theEasing) {
        return Ani.addAni(true, theTarget, theDuration, 0.0f, theFieldName, theEnd, theEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public static Ani to(Object theTarget, float theDuration, float theDelay, String theFieldName, float theEnd, Easing theEasing) {
        return Ani.addAni(false, theTarget, theDuration, theDelay, theFieldName, theEnd, theEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public static Ani from(Object theTarget, float theDuration, float theDelay, String theFieldName, float theEnd, Easing theEasing) {
        return Ani.addAni(true, theTarget, theDuration, theDelay, theFieldName, theEnd, theEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public static Ani to(Object theTarget, float theDuration, String theFieldName, float theEnd, Easing theEasing, String theCallback) {
        return Ani.addAni(false, theTarget, theDuration, 0.0f, theFieldName, theEnd, theEasing, defaultTimeMode, theTarget, theCallback);
    }

    public static Ani to(Object theTarget, float theDuration, String theFieldName, float theEnd, Easing theEasing, Object theCallbackObject, String theCallback) {
        return Ani.addAni(false, theTarget, theDuration, 0.0f, theFieldName, theEnd, theEasing, defaultTimeMode, theCallbackObject, theCallback);
    }

    public static Ani from(Object theTarget, float theDuration, String theFieldName, float theEnd, Easing theEasing, String theCallback) {
        return Ani.addAni(true, theTarget, theDuration, 0.0f, theFieldName, theEnd, theEasing, defaultTimeMode, theTarget, theCallback);
    }

    public static Ani from(Object theTarget, float theDuration, String theFieldName, float theEnd, Easing theEasing, Object theCallbackObject, String theCallback) {
        return Ani.addAni(true, theTarget, theDuration, 0.0f, theFieldName, theEnd, theEasing, defaultTimeMode, theCallbackObject, theCallback);
    }

    public static Ani to(Object theTarget, float theDuration, float theDelay, String theFieldName, float theEnd, Easing theEasing, String theCallback) {
        return Ani.addAni(false, theTarget, theDuration, theDelay, theFieldName, theEnd, theEasing, defaultTimeMode, theTarget, theCallback);
    }

    public static Ani to(Object theTarget, float theDuration, float theDelay, String theFieldName, float theEnd, Easing theEasing, Object theCallbackObject, String theCallback) {
        return Ani.addAni(false, theTarget, theDuration, theDelay, theFieldName, theEnd, theEasing, defaultTimeMode, theCallbackObject, theCallback);
    }

    public static Ani from(Object theTarget, float theDuration, float theDelay, String theFieldName, float theEnd, Easing theEasing, String theCallback) {
        return Ani.addAni(true, theTarget, theDuration, theDelay, theFieldName, theEnd, theEasing, defaultTimeMode, theTarget, theCallback);
    }

    public static Ani from(Object theTarget, float theDuration, float theDelay, String theFieldName, float theEnd, Easing theEasing, Object theCallbackObject, String theCallback) {
        return Ani.addAni(true, theTarget, theDuration, theDelay, theFieldName, theEnd, theEasing, defaultTimeMode, theCallbackObject, theCallback);
    }

    public static Ani[] to(Object theTarget, float theDuration, String thePropertyList) {
        return Ani.addAnis(false, theTarget, theDuration, 0.0f, thePropertyList, defaultEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public static Ani[] from(Object theTarget, float theDuration, String thePropertyList) {
        return Ani.addAnis(true, theTarget, theDuration, 0.0f, thePropertyList, defaultEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public static Ani[] to(Object theTarget, float theDuration, float theDelay, String thePropertyList) {
        return Ani.addAnis(false, theTarget, theDuration, theDelay, thePropertyList, defaultEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public static Ani[] from(Object theTarget, float theDuration, float theDelay, String thePropertyList) {
        return Ani.addAnis(true, theTarget, theDuration, theDelay, thePropertyList, defaultEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public static Ani[] to(Object theTarget, float theDuration, String thePropertyList, Easing theEasing) {
        return Ani.addAnis(false, theTarget, theDuration, 0.0f, thePropertyList, theEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public static Ani[] from(Object theTarget, float theDuration, String thePropertyList, Easing theEasing) {
        return Ani.addAnis(true, theTarget, theDuration, 0.0f, thePropertyList, theEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public static Ani[] to(Object theTarget, float theDuration, float theDelay, String thePropertyList, Easing theEasing) {
        return Ani.addAnis(false, theTarget, theDuration, theDelay, thePropertyList, theEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public static Ani[] from(Object theTarget, float theDuration, float theDelay, String thePropertyList, Easing theEasing) {
        return Ani.addAnis(true, theTarget, theDuration, theDelay, thePropertyList, theEasing, defaultTimeMode, theTarget, defaultCallback);
    }

    public static Ani[] to(Object theTarget, float theDuration, String thePropertyList, Easing theEasing, Object theCallbackObject, String theCallback) {
        return Ani.addAnis(false, theTarget, theDuration, 0.0f, thePropertyList, theEasing, defaultTimeMode, theCallbackObject, theCallback);
    }

    public static Ani[] from(Object theTarget, float theDuration, String thePropertyList, Easing theEasing, Object theCallbackObject, String theCallback) {
        return Ani.addAnis(true, theTarget, theDuration, 0.0f, thePropertyList, theEasing, defaultTimeMode, theCallbackObject, theCallback);
    }

    public static Ani[] to(Object theTarget, float theDuration, String thePropertyList, Easing theEasing, String theCallback) {
        return Ani.addAnis(false, theTarget, theDuration, 0.0f, thePropertyList, theEasing, defaultTimeMode, theTarget, theCallback);
    }

    public static Ani[] from(Object theTarget, float theDuration, String thePropertyList, Easing theEasing, String theCallback) {
        return Ani.addAnis(true, theTarget, theDuration, 0.0f, thePropertyList, theEasing, defaultTimeMode, theTarget, theCallback);
    }

    public static Ani[] to(Object theTarget, float theDuration, float theDelay, String thePropertyList, Easing theEasing, Object theCallbackObject, String theCallback) {
        return Ani.addAnis(false, theTarget, theDuration, theDelay, thePropertyList, theEasing, defaultTimeMode, theCallbackObject, theCallback);
    }

    public static Ani[] from(Object theTarget, float theDuration, float theDelay, String thePropertyList, Easing theEasing, Object theCallbackObject, String theCallback) {
        return Ani.addAnis(true, theTarget, theDuration, theDelay, thePropertyList, theEasing, defaultTimeMode, theCallbackObject, theCallback);
    }

    private static Ani addAni(boolean theReverse, Object theTarget, float theDuration, float theDelay, String theFieldName, float theEnd, Easing theEasing, String theTimeMode, Object theCallbackObject, String theCallback) {
        Ani.cleanAnis();
        String id = String.valueOf(System.identityHashCode(theTarget)) + "_" + theFieldName;
        if (anisLookup.containsKey(id) && defaultOverwriteMode == "OVERWRITE") {
            Ani existingAni = anisLookup.get(id);
            existingAni.setDuration(theDuration);
            existingAni.setDelay(theDelay);
            existingAni.setEasing(theEasing);
            existingAni.setTimeMode(theTimeMode);
            existingAni.setCallback(theCallback);
            existingAni.setBegin();
            existingAni.setEnd(theEnd);
            existingAni.seek(0.0f);
            if (theReverse) {
                existingAni.reverse();
            }
            return existingAni;
        }
        Ani newAni = new Ani(theTarget, theDuration, theDelay, theFieldName, theEnd, theEasing, theCallbackObject, theCallback);
        if (theReverse) {
            newAni.reverse();
        }
        anisLookup.put(id, newAni);
        return newAni;
    }

    private static Ani[] addAnis(boolean theReverse, Object theTarget, float theDuration, float theDelay, String thePropertyList, Easing theEasing, String theTimeMode, Object theCallbackObject, String theCallback) {
        String[] propertyList = PApplet.split((String)thePropertyList, (char)',');
        Ani[] tmpAnis = new Ani[propertyList.length];
        int i = 0;
        while (i < propertyList.length) {
            String[] p = PApplet.split((String)PApplet.trim((String)propertyList[i]), (char)':');
            if (p.length == 2) {
                String fieldName = p[0];
                float end = Float.parseFloat(p[1]);
                tmpAnis[i] = Ani.addAni(theReverse, theTarget, theDuration, theDelay, fieldName, end, theEasing, theTimeMode, theCallbackObject, theCallback);
            }
            ++i;
        }
        return tmpAnis;
    }

    private static void cleanAnis() {
        Iterator<Map.Entry<String, Ani>> i = anisLookup.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Ani> entry = i.next();
            Ani existingAni = entry.getValue();
            if (!existingAni.isEnded()) continue;
            i.remove();
        }
    }

    public static void killAll() {
        Iterator<Map.Entry<String, Ani>> i = anisLookup.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Ani> entry = i.next();
            Ani existingAni = entry.getValue();
            existingAni.pause();
            Ani.papplet().unregisterMethod("pre", (Object)existingAni);
            existingAni = null;
            i.remove();
        }
    }

    public static void autostart() {
        defaultAutostartMode = "AUTOSTART";
    }

    public static void noAutostart() {
        defaultAutostartMode = "NO_AUTOSTART";
    }

    public static String getAutostartMode() {
        return defaultAutostartMode;
    }

    public static void overwrite() {
        defaultOverwriteMode = "OVERWRITE";
    }

    public static void noOverwrite() {
        defaultOverwriteMode = "NO_OVERWRITE";
    }

    public static String getOverwriteMode() {
        return defaultOverwriteMode;
    }

    public static String getDefaultTimeMode() {
        return defaultTimeMode;
    }

    public static void setDefaultTimeMode(String theDefaultTimeMode) {
        defaultTimeMode = theDefaultTimeMode;
    }

    public static Easing getDefaultEasing() {
        return defaultEasing;
    }

    public static void setDefaultEasing(Easing theDefaultEasing) {
        defaultEasing = theDefaultEasing;
    }

    public static int size() {
        return anisLookup.size();
    }

    private static class LibraryNotInitializedException
    extends NullPointerException {
        private static final long serialVersionUID = -3710605630786298671L;

        LibraryNotInitializedException() {
            super("### Ani Debug ->  Call Ani.init(this); before using this library!");
        }
    }
}

